;**********************************************
; Test write and read RTC PCF8583P
; Hardware  : CP-PIC V4.0
; OSC       : 10 MHz
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 30/7/2002
;**********************************************

     LIST P=18f458
     include <p18f458.inc>

#define   BIT_SDA     PORTC,4  
#define   BIT_SCL     PORTC,3

dt1       EQU       0x20
dt2       EQU       0x21
dt3       EQU       0x22
WR_BUF    EQU       0x23
count     EQU       0x24
flag      EQU       0x29
RD_BUF    EQU       0x30
B1        EQU       0x31
B2        EQU       0x32
SDA       EQU       4
SCL       EQU       3

;*********************************************
          ORG       0x0000
          
          bcf       TRISC,4	; PORTC.4 as output
          bcf       TRISC,3	; PORTC.3 as input
          movlw     0x40           ; BAUD rate 9600
          movwf     SPBRG
          clrf      TXSTA          ; 8 bits data ,no,1 stop
          bsf       TXSTA,TXEN     ; Transmit enable
	  bsf	    TXSTA,BRGH     ; hi speed
          clrf      RCSTA
          bsf       RCSTA,SPEN     ; Asynchronous serial port enable
          bsf       RCSTA,CREN     ; continuous receive
	
          call	    START
          movlw     0xA2            ; Write SECOND to address 00
          call      WR_I2C
          movlw     02              
          call	    WR_I2C
	  movlw	    00             ;  Start second = 00 
          call	    WR_I2C
	  movlw	    00	           ;  Start minute = 00
	  call	    WR_I2C         
	  movlw     00             ;  Start Hour = 0
	  call	    WR_I2C         
	  call      STOP
          call      SDel           ; delay more than 10 mS

st        movlw     0x0C           ; Clear display
          call      SEND
          movlw     "H"
          call      SEND
          movlw     "O"
          call      SEND
          movlw     "U"
          call      SEND
          movlw     "R"
          call      SEND
          movlw     " "
          call      SEND
          movlw     " "
          call      SEND
         
	  movlw     "M"
          call      SEND
          movlw     "I"
          call      SEND
          movlw     "N"
          call      SEND
          movlw     " "
          call      SEND
          movlw     " "
          call      SEND
          movlw     "S"
          call      SEND
          movlw     "E"
          call      SEND
          movlw     "C"
          call      SEND
          movlw     0xA             ; new line
          call      SEND
          movlw     0xD
          call      SEND
 	  movlw     " "
	  call      SEND

;*********** READ HOUR *************
          call	    START           ; start condition
          movlw     0xA2            ; control address
          call	    WR_I2C          ; write control
	  movlw	    0x04            ; address Hour
	  call	    WR_I2C          ; write address
	  call	    STOP	    ; stop condition
	  call	    START           ; start condition
	  movlw	    0xA3            ; control read
	  call	    WR_I2C          ; write control
	  call	    RD_I2C	    ; read data form RTC
          movf      RD_BUF,w
          call      ADJT            ; display Hour

          movlw     " "
          call      SEND
          movlw     ":"
          call      SEND
          movlw     " "
          call      SEND
	  movlw     " "
          call      SEND
;*********** READ Min *************
          call	    START	    ; start condition
          movlw     0xA2            ; control byte
          call	    WR_I2C
	  movlw	    0x03            ; Read minute
	  call	    WR_I2C
	  call	    STOP	    ; stop condition
	  call	    START	    ; start condition
	  movlw	    0xA3	    ; control read
	  call	    WR_I2C          ; write control
	  call	    RD_I2C	    ; Read 8 bit data form RTC  
          movf      RD_BUF,w        ; save data to w
          call      ADJT            ; display minute
          
          movlw     " "
          call      SEND
          movlw     ":"
          call      SEND
          movlw     " "
          call      SEND
	 

;******** READ SEC *********
	  
          call	    START	    ; start condition
          movlw     0xA2            ; control byte
          call	    WR_I2C
	  movlw	    0x02            ; Read second
	  call	    WR_I2C
	  call	    STOP	    ; stop condition
	  call	    START           ; start condition
	  movlw	    0xA3            ; control read
	  call	    WR_I2C          ; write control
	  call	    RD_I2C	    ; read 8 bit data
          movf      RD_BUF,w
          call      ADJT            ; display second
	  call      SDel
          goto      st

;**********************************************************
; Convert time 1 byte to ASCII 2 bytes and send to display
; Input  : W
; Output : -
;**********************************************************
ADJT      movwf     B1              ; B1 = HHHH LLLL
          swapf     B1,w            ; W  = LLLL HHHH
          andlw     0x0f            ; Mask upper four bits 0000 HHHH
          addlw     0x30            ; convert to ASCII
          call      SEND            ; Send first digit
          movf      B1,w
          andlw     0x0f            ; w  = 0000 LLLL
          addlw     0x30            ; convert to ASCII
          call      SEND
          return

;********************************************************
; Send data to RS-232 2400 Buad,8 bits data, No parity, 1 stop
; Input  : W
; Output : Computer screen
;********************************************************
SEND      movwf     TXREG           ; Send recent data to TX 
wait1     lfsr      0,TXSTA
          btfss     INDF0,1         ; check TRMT bit in TXSTA register
	  goto      wait1           ; TXREG full  or TRMT = 0
          return


;****************** WRITE DATA TO I2C BUS ************************

WR_I2C	 movwf	    WR_BUF	     ; get data to buffer
	 movlw	    .8               ; counter = 8
	 movwf	    count
	 bcf	    TRISC,SCL        
	 bcf	    PORTC,SCL        ; SCL  low
	 call	    delay
WR_LOOP  rlcf	    WR_BUF,f         ; rotate data to carry flag
	 BC	    DATA_1           ; data = 1 jump to DATA_1
DATA_0   bcf	    TRISC,SDA        ; data = 0 
	 bcf	    BIT_SDA          ; SDA Lo
	 call	    pulse	     ; Get clock
	 goto	    CHK       
DATA_1   bsf	    TRISC,SDA        ; SDA Hi
	 call	    pulse
CHK	 decfsz	    count,f          ; check counter
	 goto	    WR_LOOP
	 bsf	    TRISC,SDA        ; SDA Hi
	 call	    RD_ACK           ; read acknoledge
	 return

;*********** READ DATA FORM I2C BUS **************

RD_I2C	 movlw	    .8		     ; counter = 8
	 movwf	    count         
	 bcf	    TRISC,SCL        
	 bcf	    BIT_SCL          ; SCL Lo
	 bsf	    TRISC,SDA	     ; SDA Hi
RD_LOOP  bsf	    TRISC,SCL        ; SCL Clock Hi
	 btfsc	    BIT_SDA          ; test bit data skip "0"
	 goto	    RD_1	     ; data = 1
RD_0	 bcf	    STATUS,C	     ; clear carry flag 
	 goto 	    ROTATE	     
RD_1     bsf	    STATUS,C	     ; set carry flag
ROTATE   rlcf	    RD_BUF,f         ; rotate data to buffer
	 bcf	    TRISC,SCL        
	 bcf	    BIT_SCL          ; SCL Clock Lo
	 decfsz	    count,f          ; check counter
	 goto	    RD_LOOP          
	 return

RD_ACK	 bsf	    TRISC,SDA        ; SDA Hi
         bcf	    TRISC,SCL  
	 bcf	    BIT_SCL          ; SCL Lo
	 bsf	    TRISC,SCL	     ; SCL Hi
	 btfsc	    BIT_SDA          ; check acknowledge form SDA 
	 goto	    STOP             ; NACK		
	 btfss	    BIT_SCL
	 goto	    $-1
	 bcf	    TRISC,SCL        ; SCL Lo
	 call	    delay
	 return

START     bsf       TRISC,SDA        ; SDA = hi
          bsf       TRISC,SCL        ; SCL = hi
          btfss     BIT_SCL          
	  goto	    $-1              ; wait until SCL = 1
	  btfss	    BIT_SDA
	  goto 	    $-1              ; wait until SDA = 1
          bcf       TRISC,SDA        ; SDA lo
	  bcf	    BIT_SDA
          bcf       TRISC,SCL        ; SCL lo
	  bcf	    BIT_SCL
          return

STOP	 bcf	    TRISC,SCL        
	 bcf	    BIT_SCL          ; SCL low
	 bcf	    TRISC,SDA
	 bcf	    BIT_SDA          ; SDA low
	 bsf	    TRISC,SCL        ; SCL Hi
	 bsf	    TRISC,SDA        ; SDA Hi
	 call 	    delay
	 return	 

pulse     bcf	    TRISC,SCL	     
	  bcf	    BIT_SCL          ; SCL Low
	  call	    delay
	  bsf       TRISC,SCL	     ; SCL Hi
	  call	    delay
	  bcf	    TRISC,SCL        
	  bcf	    BIT_SCL          ; SCL Lo
	  return          
;******************************
; Short delay
;******************************
SDel      movlw	    5
	  movwf	    dt1
sd3	  clrf      dt2
sd2       clrf      dt3
sd1       decfsz    dt3
          goto      sd1
          decfsz    dt2
          goto      sd2
	  decfsz    dt1
	  goto      sd3
          return
     
delay     movlw	    .15
	  movwf	    dt3
	  decfsz    dt3,f
	  goto	    $-1
	  return
          
          end

